<?php

declare(strict_types=1);

namespace Erlage\Photogram\Structures;

final class TableDependencyNode
{
    /**
     * @var string
     */
    private $tableName;

    /**
     * @var string[]
     */
    private $ids;

    public function __construct(string $tableName, array $ids)
    {
        $this -> ids = $ids;

        $this -> tableName = $tableName;
    }

    /*
    |--------------------------------------------------------------------------
    | getters
    |--------------------------------------------------------------------------
    */

    public function getTableName(): string
    {
        return $this -> tableName;
    }

    /**
     * @return string[]
     */
    public function getIds(): array
    {
        return $this -> ids;
    }

    /*
    |--------------------------------------------------------------------------
    | content adder
    |--------------------------------------------------------------------------
    */

    public function add(string $id): void
    {
        if ( ! \in_array($id, $this -> ids))
        {
            $this -> ids[] = $id;
        }
    }
}
